
function n3xt(text, element) {
  var sample = document.querySelector(element);
  if (sample.dataset.animating === 'true') return;
  var sampleH = 50; 
  var sampleT = sample.textContent; 
  var sampleNT = text; 
  sample.dataset.animating = 'true';
  sample.style.height = sampleH + 'px';

  
  var samO = document.createElement('div');
  samO.style.transformOrigin = '0 ' + sampleH / 2 + 'px -' + sampleH / 2 + 'px';
  samO.classList.add('t3xt');
  samO.textContent = sampleT;

  
  var samN = samO.cloneNode();
  samN.textContent = sampleNT;
  sample.textContent = '';
  sample.appendChild(samO);
  sample.appendChild(samN);

  samO.classList.add('t3xt-out');
  samN.classList.add('t3xt-in');

  samN.addEventListener('animationend', function (event) {
    sample.removeChild(samO);
    sample.removeChild(samN);
    sample.textContent = sampleNT;
    sample.dataset.animating = 'false';
  });
}


var phraseIndex = 1;
var wordIndex = 0;
var t3xts = [
["ایمیل:", "info@", "tsinco.ir"],
["آدرس :", "سعادت آباد-خیابان سرو شرقی", "نبش علامه-پلاک 50"],
["تلفن:", "021", "26742637"],
["آژانس ", "مسافرتی", "تدبیر"]];


// start it off
setTimeout(changetext, 200);

function changetext() {
  if (wordIndex > 2) {
    wordIndex = 0;
    phraseIndex++;
  }
  if (phraseIndex >= t3xts.length) {
    phraseIndex = 0;
  }
  var term = t3xts[phraseIndex][wordIndex];
  n3xt(term, '.t3xt-' + ++wordIndex);

  if (wordIndex == 3) {
    setTimeout(changetext, 2000);
  } else {
    setTimeout(changetext, 150);
  }
}